/*
 * Decompiled with CFR 0.152.
 */
package java2d;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.print.PrinterJob;
import java.security.AccessControlException;
import java.text.DecimalFormat;
import java.util.logging.Level;
import java.util.logging.Logger;
import java2d.AnimatingSurface;
import java2d.DemoImages;
import java2d.GlobalControls;
import java2d.Java2Demo;
import java2d.Surface;
import java2d.TextureChooser;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.border.EtchedBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public final class Tools
extends JPanel
implements ActionListener,
ChangeListener,
Runnable {
    private ImageIcon stopIcon;
    private ImageIcon startIcon;
    private Font font = new Font("serif", 0, 10);
    private Color roColor = new Color(187, 213, 238);
    private Surface surface;
    private Thread thread;
    private JPanel toolbarPanel;
    private JPanel sliderPanel;
    private JLabel label;
    private ToggleIcon bumpyIcon;
    private ToggleIcon rolloverIcon;
    private DecimalFormat decimalFormat = new DecimalFormat("000");
    protected boolean focus;
    public JToggleButton toggleB;
    public JButton printB;
    public JComboBox screenCombo;
    public JToggleButton renderB;
    public JToggleButton aliasB;
    public JToggleButton textureB;
    public JToggleButton compositeB;
    public JButton startStopB;
    public JButton cloneB;
    public boolean issueRepaint = true;
    public JToolBar toolbar;
    public JSlider slider;
    public boolean doSlider;
    public boolean isExpanded;

    public Tools(Surface surface) {
        this.surface = surface;
        this.setLayout(new BorderLayout());
        this.stopIcon = new ImageIcon(DemoImages.getImage("stop.gif", this));
        this.startIcon = new ImageIcon(DemoImages.getImage("start.gif", this));
        this.bumpyIcon = new ToggleIcon(this, Color.LIGHT_GRAY);
        this.rolloverIcon = new ToggleIcon(this, this.roColor);
        this.toggleB = new JToggleButton(this.bumpyIcon);
        this.toggleB.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
                Tools.this.focus = true;
                Tools.this.bumpyIcon.start();
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
                Tools.this.focus = false;
                Tools.this.bumpyIcon.stop();
            }
        });
        this.isExpanded = false;
        this.toggleB.addActionListener(this);
        this.toggleB.setMargin(new Insets(0, 0, -4, 0));
        this.toggleB.setBorderPainted(false);
        this.toggleB.setFocusPainted(false);
        this.toggleB.setContentAreaFilled(false);
        this.toggleB.setRolloverIcon(this.rolloverIcon);
        this.add("North", this.toggleB);
        this.toolbar = new JToolBar();
        this.toolbar.setPreferredSize(new Dimension(112, 26));
        this.toolbar.setFloatable(false);
        String string = surface.AntiAlias == RenderingHints.VALUE_ANTIALIAS_ON ? "On" : "Off";
        this.aliasB = this.addTool("A", "Antialiasing " + string, (ActionListener)this);
        string = surface.Rendering == RenderingHints.VALUE_RENDER_SPEED ? "Speed" : "Quality";
        this.renderB = this.addTool("R", "Rendering " + string, (ActionListener)this);
        string = surface.texture != null ? "On" : "Off";
        this.textureB = this.addTool("T", "Texture " + string, (ActionListener)this);
        string = surface.composite != null ? "On" : "Off";
        this.compositeB = this.addTool("C", "Composite " + string, (ActionListener)this);
        Image image = DemoImages.getImage("print.gif", this);
        this.printB = this.addTool(image, "Print the Surface", (ActionListener)this);
        if (surface instanceof AnimatingSurface) {
            String[] stringArray = DemoImages.getImage("stop.gif", this);
            this.startStopB = this.addTool((Image)stringArray, "Stop Animation", (ActionListener)this);
            this.toolbar.setPreferredSize(new Dimension(132, 26));
        }
        this.screenCombo = new JComboBox();
        this.screenCombo.setPreferredSize(new Dimension(100, 18));
        this.screenCombo.setFont(this.font);
        for (String string2 : GlobalControls.screenNames) {
            this.screenCombo.addItem(string2);
        }
        this.screenCombo.addActionListener(this);
        this.toolbarPanel = new JPanel(new FlowLayout(1, 5, 0));
        this.toolbarPanel.setLocation(0, 6);
        this.toolbarPanel.setVisible(false);
        this.toolbarPanel.add(this.toolbar);
        this.toolbarPanel.add(this.screenCombo);
        this.toolbarPanel.setBorder(new EtchedBorder());
        this.add(this.toolbarPanel);
        this.setPreferredSize(new Dimension(200, 8));
        if (surface instanceof AnimatingSurface) {
            this.sliderPanel = new JPanel(new BorderLayout());
            this.label = new JLabel(" Sleep = 030 ms");
            this.label.setForeground(Color.BLACK);
            this.sliderPanel.add((Component)this.label, "West");
            this.slider = new JSlider(0, 0, 200, 30);
            this.slider.addChangeListener(this);
            this.sliderPanel.setBorder(new EtchedBorder());
            this.sliderPanel.add(this.slider);
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent mouseEvent) {
                    if (Tools.this.toolbarPanel.isVisible()) {
                        Tools.this.invalidate();
                        Tools.this.doSlider = !Tools.this.doSlider;
                        if (Tools.this.doSlider) {
                            Tools.this.remove(Tools.this.toolbarPanel);
                            Tools.this.add(Tools.this.sliderPanel);
                        } else {
                            Tools.this.remove(Tools.this.sliderPanel);
                            Tools.this.add(Tools.this.toolbarPanel);
                        }
                        Tools.this.validate();
                        Tools.this.repaint();
                    }
                }
            });
        }
    }

    public JButton addTool(Image image, String string, ActionListener actionListener) {
        JButton jButton = new JButton((Icon)new ImageIcon(image)){
            Dimension prefSize;
            {
                this.prefSize = new Dimension(21, 22);
            }

            @Override
            public Dimension getPreferredSize() {
                return this.prefSize;
            }

            @Override
            public Dimension getMaximumSize() {
                return this.prefSize;
            }

            @Override
            public Dimension getMinimumSize() {
                return this.prefSize;
            }
        };
        this.toolbar.add(jButton);
        jButton.setFocusPainted(false);
        jButton.setSelected(true);
        jButton.setToolTipText(string);
        jButton.addActionListener(actionListener);
        return jButton;
    }

    public JToggleButton addTool(String string, String string2, ActionListener actionListener) {
        JToggleButton jToggleButton = new JToggleButton(string){
            Dimension prefSize;
            {
                this.prefSize = new Dimension(21, 22);
            }

            @Override
            public Dimension getPreferredSize() {
                return this.prefSize;
            }

            @Override
            public Dimension getMaximumSize() {
                return this.prefSize;
            }

            @Override
            public Dimension getMinimumSize() {
                return this.prefSize;
            }
        };
        this.toolbar.add(jToggleButton);
        jToggleButton.setFocusPainted(false);
        if (string2.equals("Rendering Quality") || string2.equals("Antialiasing On") || string2.equals("Texture On") || string2.equals("Composite On")) {
            jToggleButton.setSelected(true);
        } else {
            jToggleButton.setSelected(false);
        }
        jToggleButton.setToolTipText(string2);
        jToggleButton.addActionListener(actionListener);
        return jToggleButton;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object instanceof JButton) {
            JButton jButton;
            jButton.setSelected(!(jButton = (JButton)object).isSelected());
            if (jButton.getIcon() == null) {
                jButton.setBackground(jButton.isSelected() ? Color.GREEN : Color.LIGHT_GRAY);
            }
        }
        if (object.equals(this.toggleB)) {
            boolean bl = this.isExpanded = !this.isExpanded;
            if (this.isExpanded) {
                this.setPreferredSize(new Dimension(200, 38));
            } else {
                this.setPreferredSize(new Dimension(200, 6));
            }
            this.toolbarPanel.setVisible(this.isExpanded);
            if (this.sliderPanel != null) {
                this.sliderPanel.setVisible(this.isExpanded);
            }
            this.getParent().validate();
            this.toggleB.getModel().setRollover(false);
            return;
        }
        if (object.equals(this.printB)) {
            this.start();
            return;
        }
        if (object.equals(this.startStopB)) {
            if (this.startStopB.getToolTipText().equals("Stop Animation")) {
                this.startStopB.setIcon(this.startIcon);
                this.startStopB.setToolTipText("Start Animation");
                this.surface.animating.stop();
            } else {
                this.startStopB.setIcon(this.stopIcon);
                this.startStopB.setToolTipText("Stop Animation");
                this.surface.animating.start();
            }
        } else if (object.equals(this.aliasB)) {
            if (this.aliasB.getToolTipText().equals("Antialiasing On")) {
                this.aliasB.setToolTipText("Antialiasing Off");
            } else {
                this.aliasB.setToolTipText("Antialiasing On");
            }
            this.surface.setAntiAlias(this.aliasB.isSelected());
        } else if (object.equals(this.renderB)) {
            if (this.renderB.getToolTipText().equals("Rendering Quality")) {
                this.renderB.setToolTipText("Rendering Speed");
            } else {
                this.renderB.setToolTipText("Rendering Quality");
            }
            this.surface.setRendering(this.renderB.isSelected());
        } else if (object.equals(this.textureB)) {
            if (this.textureB.getToolTipText().equals("Texture On")) {
                this.textureB.setToolTipText("Texture Off");
                this.surface.setTexture(null);
                this.surface.clearSurface = true;
            } else {
                this.textureB.setToolTipText("Texture On");
                this.surface.setTexture(TextureChooser.texture);
            }
        } else if (object.equals(this.compositeB)) {
            if (this.compositeB.getToolTipText().equals("Composite On")) {
                this.compositeB.setToolTipText("Composite Off");
            } else {
                this.compositeB.setToolTipText("Composite On");
            }
            this.surface.setComposite(this.compositeB.isSelected());
        } else if (object.equals(this.screenCombo)) {
            this.surface.setImageType(this.screenCombo.getSelectedIndex());
        }
        if (this.issueRepaint && this.surface.animating != null) {
            if (this.surface.getSleepAmount() != 0L && this.surface.animating.running()) {
                this.surface.animating.doRepaint();
            }
        } else if (this.issueRepaint) {
            this.surface.repaint();
        }
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        int n = this.slider.getValue();
        this.label.setText(" Sleep = " + this.decimalFormat.format(n) + " ms");
        this.label.repaint();
        this.surface.setSleepAmount(n);
    }

    public void start() {
        this.thread = new Thread(this);
        this.thread.setPriority(10);
        this.thread.setName("Printing " + this.surface.name);
        this.thread.start();
    }

    public synchronized void stop() {
        this.thread = null;
        this.notifyAll();
    }

    @Override
    public void run() {
        boolean bl = false;
        if (this.surface.animating != null && this.surface.animating.running()) {
            bl = true;
            this.startStopB.doClick();
        }
        try {
            PrinterJob printerJob = PrinterJob.getPrinterJob();
            printerJob.setPrintable(this.surface);
            boolean bl2 = true;
            HashPrintRequestAttributeSet hashPrintRequestAttributeSet = new HashPrintRequestAttributeSet();
            if (!Java2Demo.printCB.isSelected()) {
                bl2 = printerJob.printDialog(hashPrintRequestAttributeSet);
            }
            if (bl2) {
                printerJob.print(hashPrintRequestAttributeSet);
            }
        }
        catch (AccessControlException accessControlException) {
            String string = "Applet access control exception; to allow access to printer, run policytool and set\npermission for \"queuePrintJob\" in RuntimePermission.";
            JOptionPane.showMessageDialog(this, string, "Printer Access Error", 0);
        }
        catch (Exception exception) {
            Logger.getLogger(Tools.class.getName()).log(Level.SEVERE, null, exception);
        }
        if (bl) {
            this.startStopB.doClick();
        }
        this.thread = null;
    }

    static class ToggleIcon
    implements Icon,
    Runnable {
        private Color shadowColor = new Color(102, 102, 153);
        private Color fillColor;
        private Tools tools;
        private Thread thread;

        public ToggleIcon(Tools tools, Color color) {
            this.tools = tools;
            this.fillColor = color;
        }

        @Override
        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            int n3 = this.getIconWidth();
            int n4 = this.getIconHeight();
            graphics.setColor(this.fillColor);
            graphics.fillRect(0, 0, n3, n4);
            while (n < n3 - 2) {
                graphics.setColor(Color.WHITE);
                graphics.fillRect(n, 1, 1, 1);
                graphics.fillRect(n + 2, 3, 1, 1);
                graphics.setColor(this.shadowColor);
                graphics.fillRect(n + 1, 2, 1, 1);
                graphics.fillRect(n + 3, 4, 1, 1);
                n += 4;
            }
        }

        @Override
        public int getIconWidth() {
            return this.tools.getSize().width;
        }

        @Override
        public int getIconHeight() {
            return 6;
        }

        public void start() {
            this.thread = new Thread(this);
            this.thread.setPriority(1);
            this.thread.setName("ToggleIcon");
            this.thread.start();
        }

        public synchronized void stop() {
            if (this.thread != null) {
                this.thread.interrupt();
            }
            this.thread = null;
        }

        @Override
        public void run() {
            try {
                Thread.sleep(400L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (this.tools.focus && this.thread != null) {
                this.tools.toggleB.doClick();
            }
            this.thread = null;
        }
    }
}

