/*
 * Decompiled with CFR 0.152.
 */
package java2d.demos.Images;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.geom.GeneralPath;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import java2d.Surface;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriter;
import javax.imageio.plugins.jpeg.JPEGImageWriteParam;
import javax.imageio.stream.ImageOutputStream;

public class JPEGFlip
extends Surface {
    private static Image img;

    public JPEGFlip() {
        this.setBackground(Color.WHITE);
        img = this.getImage("duke.gif");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void render(int n, int n2, Graphics2D graphics2D) {
        int n3 = n2 / 2;
        BufferedImage bufferedImage = new BufferedImage(n, n3, 1);
        Graphics2D graphics2D2 = bufferedImage.createGraphics();
        graphics2D2.setRenderingHints(graphics2D.getRenderingHints());
        graphics2D2.setBackground(this.getBackground());
        graphics2D2.clearRect(0, 0, n, n3);
        graphics2D2.setColor(Color.GREEN.darker());
        GeneralPath generalPath = new GeneralPath(1);
        generalPath.moveTo((float)(-n) / 2.0f, (float)(-n3) / 8.0f);
        generalPath.lineTo((float)n / 2.0f, (float)(-n3) / 8.0f);
        generalPath.lineTo((float)(-n) / 4.0f, (float)n3 / 2.0f);
        generalPath.lineTo(0.0f, (float)(-n3) / 2.0f);
        generalPath.lineTo((float)n / 4.0f, (float)n3 / 2.0f);
        generalPath.closePath();
        graphics2D2.translate(n / 2, n3 / 2);
        graphics2D2.fill(generalPath);
        int n4 = img.getWidth(this);
        int n5 = img.getHeight(this);
        if ((double)n3 < (double)n5 * 1.5) {
            n5 = (int)((double)n5 * ((double)n3 / ((double)n5 * 1.5)));
        }
        graphics2D2.drawImage(img, -img.getWidth(this) / 2, -n5 / 2, n4, n5, this);
        graphics2D.drawImage((Image)bufferedImage, 0, 0, this);
        graphics2D.setFont(new Font("Dialog", 0, 10));
        graphics2D.setColor(Color.BLACK);
        graphics2D.drawString("BufferedImage", 4, 12);
        BufferedImage bufferedImage2 = null;
        ImageOutputStream imageOutputStream = null;
        ByteArrayOutputStream byteArrayOutputStream = null;
        ByteArrayInputStream byteArrayInputStream = null;
        try {
            byteArrayOutputStream = new ByteArrayOutputStream();
            imageOutputStream = ImageIO.createImageOutputStream(byteArrayOutputStream);
            ImageWriter imageWriter = ImageIO.getImageWritersByFormatName("JPEG").next();
            JPEGImageWriteParam jPEGImageWriteParam = new JPEGImageWriteParam(null);
            jPEGImageWriteParam.setCompressionMode(2);
            jPEGImageWriteParam.setCompressionQuality(1.0f);
            imageWriter.setOutput(imageOutputStream);
            imageWriter.write(null, new IIOImage(bufferedImage, null, null), jPEGImageWriteParam);
            byteArrayInputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
            bufferedImage2 = ImageIO.read(byteArrayInputStream);
        }
        catch (Exception exception) {
            graphics2D.setColor(Color.RED);
            graphics2D.drawString("Error encoding or decoding the image", 5, n3 * 2 - 5);
            return;
        }
        finally {
            if (imageOutputStream != null) {
                try {
                    imageOutputStream.close();
                }
                catch (IOException iOException) {
                    Logger.getLogger(JPEGFlip.class.getName()).log(Level.SEVERE, null, iOException);
                }
            }
            if (byteArrayOutputStream != null) {
                try {
                    byteArrayOutputStream.close();
                }
                catch (IOException iOException) {
                    Logger.getLogger(JPEGFlip.class.getName()).log(Level.SEVERE, null, iOException);
                }
            }
            if (byteArrayInputStream != null) {
                try {
                    byteArrayInputStream.close();
                }
                catch (IOException iOException) {
                    Logger.getLogger(JPEGFlip.class.getName()).log(Level.SEVERE, null, iOException);
                }
            }
        }
        if (bufferedImage2 == null) {
            graphics2D.setColor(Color.RED);
            graphics2D.drawString("Error reading the image", 5, n3 * 2 - 5);
            return;
        }
        graphics2D.drawImage(bufferedImage2, n, n3 * 2, -n, -n3, null);
        graphics2D.drawString("JPEGImage Flipped", 4, n3 * 2 - 4);
        graphics2D.drawLine(0, n3, n, n3);
    }

    public static void main(String[] stringArray) {
        JPEGFlip.createDemoFrame(new JPEGFlip());
    }
}

