/*
 * Decompiled with CFR 0.152.
 */
package java2d;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java2d.CloningFeature;
import java2d.CustomControlsContext;
import java2d.DemoFonts;
import java2d.DemoGroup;
import java2d.DemoImages;
import java2d.DemoPanel;
import java2d.GlobalControls;
import java2d.GlobalPanel;
import java2d.Intro;
import java2d.Java2DemoApplet;
import java2d.MemoryMonitor;
import java2d.PerformanceMonitor;
import java2d.RunWindow;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JColorChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JProgressBar;
import javax.swing.JSeparator;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.EtchedBorder;

public class Java2Demo
extends JPanel
implements ItemListener,
ActionListener {
    static Java2Demo demo;
    static GlobalControls controls;
    static MemoryMonitor memorymonitor;
    static PerformanceMonitor performancemonitor;
    static JTabbedPane tabbedPane;
    static JLabel progressLabel;
    static JProgressBar progressBar;
    static DemoGroup[] group;
    static JCheckBoxMenuItem verboseCB;
    static JCheckBoxMenuItem ccthreadCB;
    static JCheckBoxMenuItem printCB;
    static Color backgroundColor;
    static JCheckBoxMenuItem memoryCB;
    static JCheckBoxMenuItem perfCB;
    static Intro intro;
    static String[][] demos;
    private JCheckBoxMenuItem controlsCB;
    private JMenuItem runMI;
    private JMenuItem cloneMI;
    private JMenuItem fileMI;
    private JMenuItem backgMI;
    private RunWindow runwindow;
    private CloningFeature cloningfeature;
    private JFrame rf;
    private JFrame cf;

    public Java2Demo() {
        this.setLayout(new BorderLayout());
        this.setBorder(new EtchedBorder());
        this.add((Component)this.createMenuBar(), "North");
        progressBar.setMaximum(13);
        progressLabel.setText("Loading images");
        DemoImages.newDemoImages();
        progressBar.setValue(progressBar.getValue() + 1);
        progressLabel.setText("Loading fonts");
        DemoFonts.newDemoFonts();
        progressBar.setValue(progressBar.getValue() + 1);
        progressLabel.setText("Loading Intro");
        intro = new Intro();
        progressBar.setValue(progressBar.getValue() + 1);
        UIManager.put("Button.margin", new Insets(0, 0, 0, 0));
        controls = new GlobalControls();
        memorymonitor = new MemoryMonitor();
        performancemonitor = new PerformanceMonitor();
        GlobalPanel globalPanel = new GlobalPanel();
        tabbedPane = new JTabbedPane();
        tabbedPane.setFont(new Font("serif", 0, 12));
        tabbedPane.addTab("", new J2DIcon(), globalPanel);
        tabbedPane.addChangeListener(globalPanel);
        group = new DemoGroup[demos.length];
        for (int i = 0; i < demos.length; ++i) {
            progressLabel.setText("Loading demos." + demos[i][0]);
            Java2Demo.group[i] = new DemoGroup(demos[i][0]);
            tabbedPane.addTab(demos[i][0], null);
            progressBar.setValue(progressBar.getValue() + 1);
        }
        this.add((Component)tabbedPane, "Center");
    }

    private JMenuBar createMenuBar() {
        JMenu jMenu;
        JPopupMenu.setDefaultLightWeightPopupEnabled(false);
        JMenuBar jMenuBar = new JMenuBar();
        if (Java2DemoApplet.applet == null) {
            jMenu = jMenuBar.add(new JMenu("File"));
            this.fileMI = jMenu.add(new JMenuItem("Exit"));
            this.fileMI.addActionListener(this);
        }
        jMenu = jMenuBar.add(new JMenu("Options"));
        this.controlsCB = (JCheckBoxMenuItem)jMenu.add(new JCheckBoxMenuItem("Global Controls", true));
        this.controlsCB.addItemListener(this);
        memoryCB = (JCheckBoxMenuItem)jMenu.add(new JCheckBoxMenuItem("Memory Monitor", true));
        memoryCB.addItemListener(this);
        perfCB = (JCheckBoxMenuItem)jMenu.add(new JCheckBoxMenuItem("Performance Monitor", true));
        perfCB.addItemListener(this);
        jMenu.add(new JSeparator());
        ccthreadCB = (JCheckBoxMenuItem)jMenu.add(new JCheckBoxMenuItem("Custom Controls Thread"));
        ccthreadCB.addItemListener(this);
        printCB = (JCheckBoxMenuItem)jMenu.add(printCB);
        verboseCB = (JCheckBoxMenuItem)jMenu.add(new JCheckBoxMenuItem("Verbose"));
        jMenu.add(new JSeparator());
        this.backgMI = jMenu.add(new JMenuItem("Background Color"));
        this.backgMI.addActionListener(this);
        this.runMI = jMenu.add(new JMenuItem("Run Window"));
        this.runMI.addActionListener(this);
        this.cloneMI = jMenu.add(new JMenuItem("Cloning Feature"));
        this.cloneMI.addActionListener(this);
        return jMenuBar;
    }

    public void createRunWindow() {
        if (this.rf != null) {
            this.rf.toFront();
            return;
        }
        this.runwindow = new RunWindow();
        WindowAdapter windowAdapter = new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                Java2Demo.this.runwindow.stop();
                Java2Demo.this.rf.dispose();
            }

            @Override
            public void windowClosed(WindowEvent windowEvent) {
                Java2Demo.this.rf = null;
            }
        };
        this.rf = new JFrame("Run");
        this.rf.addWindowListener(windowAdapter);
        this.rf.getContentPane().add("Center", this.runwindow);
        this.rf.pack();
        if (Java2DemoApplet.applet == null) {
            this.rf.setSize(new Dimension(200, 125));
        } else {
            this.rf.setSize(new Dimension(200, 150));
        }
        this.rf.setVisible(true);
    }

    public void startRunWindow() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Java2Demo.this.runwindow.doRunAction();
            }
        });
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource().equals(this.fileMI)) {
            System.exit(0);
        } else if (actionEvent.getSource().equals(this.runMI)) {
            this.createRunWindow();
        } else if (actionEvent.getSource().equals(this.cloneMI)) {
            if (this.cloningfeature == null) {
                this.cloningfeature = new CloningFeature();
                WindowAdapter windowAdapter = new WindowAdapter(){

                    @Override
                    public void windowClosing(WindowEvent windowEvent) {
                        Java2Demo.this.cloningfeature.stop();
                        Java2Demo.this.cf.dispose();
                    }

                    @Override
                    public void windowClosed(WindowEvent windowEvent) {
                        Java2Demo.this.cloningfeature = null;
                    }
                };
                this.cf = new JFrame("Cloning Demo");
                this.cf.addWindowListener(windowAdapter);
                this.cf.getContentPane().add("Center", this.cloningfeature);
                this.cf.pack();
                this.cf.setSize(new Dimension(320, 330));
                this.cf.setVisible(true);
            } else {
                this.cf.toFront();
            }
        } else if (actionEvent.getSource().equals(this.backgMI)) {
            backgroundColor = JColorChooser.showDialog(this, "Background Color", Color.white);
            for (int i = 1; i < tabbedPane.getTabCount(); ++i) {
                JPanel jPanel = group[i - 1].getPanel();
                for (int j = 0; j < jPanel.getComponentCount(); ++j) {
                    DemoPanel demoPanel = (DemoPanel)jPanel.getComponent(j);
                    if (demoPanel.surface == null) continue;
                    demoPanel.surface.setBackground(backgroundColor);
                }
            }
        }
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getSource().equals(this.controlsCB)) {
            boolean bl = !controls.isVisible();
            controls.setVisible(bl);
            for (Component component : Java2Demo.controls.texturechooser.getComponents()) {
                component.setVisible(bl);
            }
        } else if (itemEvent.getSource().equals(memoryCB)) {
            if (memorymonitor.isVisible()) {
                memorymonitor.setVisible(false);
                Java2Demo.memorymonitor.surf.setVisible(false);
                Java2Demo.memorymonitor.surf.stop();
            } else {
                memorymonitor.setVisible(true);
                Java2Demo.memorymonitor.surf.setVisible(true);
                Java2Demo.memorymonitor.surf.start();
            }
        } else if (itemEvent.getSource().equals(perfCB)) {
            if (performancemonitor.isVisible()) {
                performancemonitor.setVisible(false);
                Java2Demo.performancemonitor.surf.setVisible(false);
                Java2Demo.performancemonitor.surf.stop();
            } else {
                performancemonitor.setVisible(true);
                Java2Demo.performancemonitor.surf.setVisible(true);
                Java2Demo.performancemonitor.surf.start();
            }
        } else if (itemEvent.getSource().equals(ccthreadCB)) {
            CustomControlsContext.State state;
            CustomControlsContext.State state2 = state = ccthreadCB.isSelected() ? CustomControlsContext.State.START : CustomControlsContext.State.STOP;
            if (tabbedPane.getSelectedIndex() != 0) {
                JPanel jPanel = group[tabbedPane.getSelectedIndex() - 1].getPanel();
                for (int i = 0; i < jPanel.getComponentCount(); ++i) {
                    DemoPanel demoPanel = (DemoPanel)jPanel.getComponent(i);
                    if (demoPanel.ccc == null) continue;
                    demoPanel.ccc.handleThread(state);
                }
            }
        }
        this.revalidate();
    }

    public void start() {
        if (tabbedPane.getSelectedIndex() == 0) {
            intro.start();
        } else {
            group[tabbedPane.getSelectedIndex() - 1].setup(false);
            if (Java2Demo.memorymonitor.surf.thread == null && memoryCB.getState()) {
                Java2Demo.memorymonitor.surf.start();
            }
            if (Java2Demo.performancemonitor.surf.thread == null && perfCB.getState()) {
                Java2Demo.performancemonitor.surf.start();
            }
        }
    }

    public void stop() {
        if (tabbedPane.getSelectedIndex() == 0) {
            intro.stop();
        } else {
            Java2Demo.memorymonitor.surf.stop();
            Java2Demo.performancemonitor.surf.stop();
            int n = tabbedPane.getSelectedIndex() - 1;
            group[n].shutDown(group[n].getPanel());
        }
    }

    static void addToGridBag(JPanel jPanel, Component component, int n, int n2, int n3, int n4, double d, double d2) {
        GridBagLayout gridBagLayout = (GridBagLayout)jPanel.getLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridx = n;
        gridBagConstraints.gridy = n2;
        gridBagConstraints.gridwidth = n3;
        gridBagConstraints.gridheight = n4;
        gridBagConstraints.weightx = d;
        gridBagConstraints.weighty = d2;
        jPanel.add(component);
        gridBagLayout.setConstraints(component, gridBagConstraints);
    }

    public static void main(String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            String string;
            if (stringArray[i].startsWith("-h") || stringArray[i].startsWith("-help")) {
                string = "\njava -jar Java2Demo.jar -runs=5 -delay=5 -screen=5 -antialias=true -rendering=true -texture=true -composite=true -verbose -print -columns=3 -buffers=5,10 -ccthread -zoom -maxscreen \n";
                System.out.println(string);
                string = "    -runs=5       Number of runs to execute\n    -delay=5      Sleep amount between tabs\n    -antialias=   true or false for antialiasing\n    -rendering=   true or false for quality or speed\n    -texture=     true or false for texturing\n    -composite=   true or false for compositing\n    -verbose      output Surface graphic states \n    -print        during run print the Surface, use the Default Printer\n    -columns=3    # of columns to use in clone layout \n    -screen=3     demos all use this screen type \n    -buffers=5,10 during run - clone to see screens five through ten\n    -ccthread     Invoke the Custom Controls Thread \n    -zoom         mouseClick on surface for zoom in  \n    -maxscreen    take up the entire monitor screen \n";
                System.out.println(string);
                string = "Examples : \n    Print all of the demos : \n        java -jar Java2Demo.jar -runs=1 -delay=60 -print \n    Run zoomed in with custom control thread \n        java -jar Java2Demo.jar -runs=10 -zoom -ccthread\n";
                System.out.println(string);
                System.exit(0);
                continue;
            }
            if (!stringArray[i].startsWith("-delay=")) continue;
            string = stringArray[i].substring(stringArray[i].indexOf(61) + 1);
            RunWindow.delay = Integer.parseInt(string);
        }
        JFrame jFrame = new JFrame("Java 2D(TM) Demo");
        jFrame.getAccessibleContext().setAccessibleDescription("A sample application to demonstrate Java2D features");
        int n = 400;
        int n2 = 200;
        jFrame.setSize(n, n2);
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        jFrame.setLocation(dimension.width / 2 - n / 2, dimension.height / 2 - n2 / 2);
        jFrame.setCursor(Cursor.getPredefinedCursor(3));
        jFrame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                System.exit(0);
            }

            @Override
            public void windowDeiconified(WindowEvent windowEvent) {
                if (demo != null) {
                    demo.start();
                }
            }

            @Override
            public void windowIconified(WindowEvent windowEvent) {
                if (demo != null) {
                    demo.stop();
                }
            }
        });
        JOptionPane.setRootFrame(jFrame);
        JPanel jPanel = new JPanel(){

            @Override
            public Insets getInsets() {
                return new Insets(40, 30, 20, 30);
            }
        };
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        jFrame.getContentPane().add((Component)jPanel, "Center");
        Dimension dimension2 = new Dimension(400, 20);
        progressLabel = new JLabel("Loading, please wait...");
        progressLabel.setAlignmentX(0.5f);
        progressLabel.setMaximumSize(dimension2);
        progressLabel.setPreferredSize(dimension2);
        jPanel.add(progressLabel);
        jPanel.add(Box.createRigidArea(new Dimension(1, 20)));
        progressBar = new JProgressBar();
        progressBar.setStringPainted(true);
        progressLabel.setLabelFor(progressBar);
        progressBar.setAlignmentX(0.5f);
        progressBar.setMinimum(0);
        progressBar.setValue(0);
        progressBar.getAccessibleContext().setAccessibleName("Java2D loading progress");
        jPanel.add(progressBar);
        jFrame.setVisible(true);
        demo = new Java2Demo();
        jFrame.getContentPane().removeAll();
        jFrame.getContentPane().setLayout(new BorderLayout());
        jFrame.getContentPane().add((Component)demo, "Center");
        n = 730;
        n2 = 570;
        jFrame.setLocation(dimension.width / 2 - n / 2, dimension.height / 2 - n2 / 2);
        jFrame.setSize(n, n2);
        jFrame.setCursor(Cursor.getPredefinedCursor(0));
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            String string2 = string.substring(string.indexOf(61) + 1);
            if (string.startsWith("-runs=")) {
                RunWindow.numRuns = Integer.parseInt(string2);
                RunWindow.exit = true;
                demo.createRunWindow();
                continue;
            }
            if (string.startsWith("-screen=")) {
                GlobalControls.screenCombo.setSelectedIndex(Integer.parseInt(string2));
                continue;
            }
            if (string.startsWith("-antialias=")) {
                Java2Demo.controls.aliasCB.setSelected(string2.endsWith("true"));
                continue;
            }
            if (string.startsWith("-rendering=")) {
                Java2Demo.controls.renderCB.setSelected(string2.endsWith("true"));
                continue;
            }
            if (string.startsWith("-texture=")) {
                Java2Demo.controls.textureCB.setSelected(string2.endsWith("true"));
                continue;
            }
            if (string.startsWith("-composite=")) {
                Java2Demo.controls.compositeCB.setSelected(string2.endsWith("true"));
                continue;
            }
            if (string.startsWith("-verbose")) {
                verboseCB.setSelected(true);
                continue;
            }
            if (string.startsWith("-print")) {
                printCB.setSelected(true);
                RunWindow.printCB.setSelected(true);
                continue;
            }
            if (string.startsWith("-columns=")) {
                DemoGroup.columns = Integer.parseInt(string2);
                continue;
            }
            if (string.startsWith("-buffers=")) {
                RunWindow.buffersFlag = true;
                int n3 = string.indexOf(61) + 1;
                int n4 = string.indexOf(44);
                String string3 = string.substring(n3, n4);
                RunWindow.bufBeg = Integer.parseInt(string3);
                string3 = string.substring(n4 + 1, string.length());
                RunWindow.bufEnd = Integer.parseInt(string3);
                continue;
            }
            if (string.startsWith("-ccthread")) {
                ccthreadCB.setSelected(true);
                continue;
            }
            if (string.startsWith("-zoom")) {
                RunWindow.zoomCB.setSelected(true);
                continue;
            }
            if (!string.startsWith("-maxscreen")) continue;
            jFrame.setLocation(0, 0);
            jFrame.setSize(dimension.width, dimension.height);
        }
        jFrame.validate();
        jFrame.repaint();
        jFrame.getFocusTraversalPolicy().getDefaultComponent(jFrame).requestFocus();
        demo.start();
        if (RunWindow.exit) {
            demo.startRunWindow();
        }
    }

    static {
        printCB = new JCheckBoxMenuItem("Default Printer");
        demos = new String[][]{{"Arcs_Curves", "Arcs", "BezierAnim", "Curves", "Ellipses"}, {"Clipping", "Areas", "ClipAnim", "Intersection", "Text"}, {"Colors", "BullsEye", "ColorConvert", "Rotator3D"}, {"Composite", "ACimages", "ACrules", "FadeAnim"}, {"Fonts", "AttributedStr", "Highlighting", "Outline", "Tree"}, {"Images", "DukeAnim", "ImageOps", "JPEGFlip", "WarpImage"}, {"Lines", "Caps", "Dash", "Joins", "LineAnim"}, {"Mix", "Balls", "BezierScroller", "Stars3D"}, {"Paint", "GradAnim", "Gradient", "Texture", "TextureAnim"}, {"Paths", "Append", "CurveQuadTo", "FillStroke", "WindingRule"}, {"Transforms", "Rotate", "SelectTx", "TransformAnim"}};
    }

    static class J2DIcon
    implements Icon {
        private static Color myBlue = new Color(94, 105, 176);
        private static Color myBlack = new Color(20, 20, 20);
        private static Font font = new Font("serif", 1, 12);
        private FontRenderContext frc = new FontRenderContext(null, true, true);
        private TextLayout tl = new TextLayout("Java2D", font, this.frc);

        J2DIcon() {
        }

        @Override
        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            graphics2D.setFont(font);
            if (tabbedPane.getSelectedIndex() == 0) {
                graphics2D.setColor(myBlue);
            } else {
                graphics2D.setColor(myBlack);
            }
            this.tl.draw(graphics2D, n, n2 + 15);
        }

        @Override
        public int getIconWidth() {
            return 40;
        }

        @Override
        public int getIconHeight() {
            return 22;
        }
    }
}

