/*
 * Decompiled with CFR 0.152.
 */
package components;

import java.awt.Dimension;
import java.net.URL;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class SplitPaneDemo
extends JPanel
implements ListSelectionListener {
    private JLabel picture;
    private JList list;
    private JSplitPane splitPane;
    private String[] imageNames = new String[]{"Bird", "Cat", "Dog", "Rabbit", "Pig", "dukeWaveRed", "kathyCosmo", "lainesTongue", "left", "middle", "right", "stickerface"};

    public SplitPaneDemo() {
        this.list = new JList<String>(this.imageNames);
        this.list.setSelectionMode(0);
        this.list.setSelectedIndex(0);
        this.list.addListSelectionListener(this);
        JScrollPane listScrollPane = new JScrollPane(this.list);
        this.picture = new JLabel();
        this.picture.setFont(this.picture.getFont().deriveFont(2));
        this.picture.setHorizontalAlignment(0);
        JScrollPane pictureScrollPane = new JScrollPane(this.picture);
        this.splitPane = new JSplitPane(1, listScrollPane, pictureScrollPane);
        this.splitPane.setOneTouchExpandable(true);
        this.splitPane.setDividerLocation(150);
        Dimension minimumSize = new Dimension(100, 50);
        listScrollPane.setMinimumSize(minimumSize);
        pictureScrollPane.setMinimumSize(minimumSize);
        this.splitPane.setPreferredSize(new Dimension(400, 200));
        this.updateLabel(this.imageNames[this.list.getSelectedIndex()]);
    }

    public void valueChanged(ListSelectionEvent e) {
        JList list = (JList)e.getSource();
        this.updateLabel(this.imageNames[list.getSelectedIndex()]);
    }

    protected void updateLabel(String name) {
        ImageIcon icon = SplitPaneDemo.createImageIcon("images/" + name + ".gif");
        this.picture.setIcon(icon);
        if (icon != null) {
            this.picture.setText(null);
        } else {
            this.picture.setText("Image not found");
        }
    }

    public JList getImageList() {
        return this.list;
    }

    public JSplitPane getSplitPane() {
        return this.splitPane;
    }

    protected static ImageIcon createImageIcon(String path) {
        URL imgURL = SplitPaneDemo.class.getResource(path);
        if (imgURL != null) {
            return new ImageIcon(imgURL);
        }
        System.err.println("Couldn't find file: " + path);
        return null;
    }

    private static void createAndShowGUI() {
        JFrame frame = new JFrame("SplitPaneDemo");
        frame.setDefaultCloseOperation(3);
        SplitPaneDemo splitPaneDemo = new SplitPaneDemo();
        frame.getContentPane().add(splitPaneDemo.getSplitPane());
        frame.pack();
        frame.setVisible(true);
    }

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                SplitPaneDemo.createAndShowGUI();
            }
        });
    }
}

