/*
 * Decompiled with CFR 0.152.
 */
package components;

import components.SplitPaneDemo;
import java.awt.Dimension;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JSplitPane;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class SplitPaneDemo2
extends JFrame
implements ListSelectionListener {
    private JLabel label;

    public SplitPaneDemo2() {
        super("SplitPaneDemo2");
        SplitPaneDemo splitPaneDemo = new SplitPaneDemo();
        JSplitPane top = splitPaneDemo.getSplitPane();
        splitPaneDemo.getImageList().addListSelectionListener(this);
        top.setBorder(null);
        this.label = new JLabel("Click on an image name in the list.", 0);
        JSplitPane splitPane = new JSplitPane(0, top, this.label);
        splitPane.setOneTouchExpandable(true);
        splitPane.setDividerLocation(180);
        top.setMinimumSize(new Dimension(100, 50));
        this.label.setMinimumSize(new Dimension(100, 30));
        this.getContentPane().add(splitPane);
    }

    public void valueChanged(ListSelectionEvent e) {
        if (e.getValueIsAdjusting()) {
            return;
        }
        JList theList = (JList)e.getSource();
        if (theList.isSelectionEmpty()) {
            this.label.setText("Nothing selected.");
        } else {
            int index = theList.getSelectedIndex();
            this.label.setText("Selected image number " + index);
        }
    }

    private static void createAndShowGUI() {
        SplitPaneDemo2 frame = new SplitPaneDemo2();
        frame.setDefaultCloseOperation(3);
        frame.pack();
        frame.setVisible(true);
    }

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                SplitPaneDemo2.createAndShowGUI();
            }
        });
    }
}

