/*
 * Decompiled with CFR 0.152.
 */
package components;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

public class ToolBarDemo2
extends JPanel
implements ActionListener {
    protected JTextArea textArea;
    protected String newline = "\n";
    private static final String PREVIOUS = "previous";
    private static final String UP = "up";
    private static final String NEXT = "next";
    private static final String SOMETHING_ELSE = "other";
    private static final String TEXT_ENTERED = "text";

    public ToolBarDemo2() {
        super(new BorderLayout());
        JToolBar toolBar = new JToolBar("Still draggable");
        this.addButtons(toolBar);
        toolBar.setFloatable(false);
        toolBar.setRollover(true);
        this.textArea = new JTextArea(5, 30);
        this.textArea.setEditable(false);
        JScrollPane scrollPane = new JScrollPane(this.textArea);
        this.setPreferredSize(new Dimension(450, 130));
        this.add((Component)toolBar, "First");
        this.add((Component)scrollPane, "Center");
    }

    protected void addButtons(JToolBar toolBar) {
        JButton button = null;
        button = this.makeNavigationButton("Back24", PREVIOUS, "Back to previous something-or-other", "Previous");
        toolBar.add(button);
        button = this.makeNavigationButton("Up24", UP, "Up to something-or-other", "Up");
        toolBar.add(button);
        button = this.makeNavigationButton("Forward24", NEXT, "Forward to something-or-other", "Next");
        toolBar.add(button);
        toolBar.addSeparator();
        button = new JButton("Another button");
        button.setActionCommand(SOMETHING_ELSE);
        button.setToolTipText("Something else");
        button.addActionListener(this);
        toolBar.add(button);
        JTextField textField = new JTextField("A text field");
        textField.setColumns(10);
        textField.addActionListener(this);
        textField.setActionCommand(TEXT_ENTERED);
        toolBar.add(textField);
    }

    protected JButton makeNavigationButton(String imageName, String actionCommand, String toolTipText, String altText) {
        String imgLocation = "images/" + imageName + ".gif";
        URL imageURL = ToolBarDemo2.class.getResource(imgLocation);
        JButton button = new JButton();
        button.setActionCommand(actionCommand);
        button.setToolTipText(toolTipText);
        button.addActionListener(this);
        if (imageURL != null) {
            button.setIcon(new ImageIcon(imageURL, altText));
        } else {
            button.setText(altText);
            System.err.println("Resource not found: " + imgLocation);
        }
        return button;
    }

    public void actionPerformed(ActionEvent e) {
        String cmd = e.getActionCommand();
        String description = null;
        if (PREVIOUS.equals(cmd)) {
            description = "taken you to the previous <something>.";
        } else if (UP.equals(cmd)) {
            description = "taken you up one level to <something>.";
        } else if (NEXT.equals(cmd)) {
            description = "taken you to the next <something>.";
        } else if (SOMETHING_ELSE.equals(cmd)) {
            description = "done something else.";
        } else if (TEXT_ENTERED.equals(cmd)) {
            JTextField tf = (JTextField)e.getSource();
            String text = tf.getText();
            tf.setText("");
            description = "done something with this text: " + this.newline + "  \"" + text + "\"";
        }
        this.displayResult("If this were a real app, it would have " + description);
    }

    protected void displayResult(String actionDescription) {
        this.textArea.append(actionDescription + this.newline);
        this.textArea.setCaretPosition(this.textArea.getDocument().getLength());
    }

    private static void createAndShowGUI() {
        JFrame frame = new JFrame("ToolBarDemo2");
        frame.setDefaultCloseOperation(3);
        frame.add(new ToolBarDemo2());
        frame.pack();
        frame.setVisible(true);
    }

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                UIManager.put("swing.boldMetal", Boolean.FALSE);
                ToolBarDemo2.createAndShowGUI();
            }
        });
    }
}

