/*
 * Decompiled with CFR 0.152.
 */
package misc;

import java.awt.Container;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.print.PrinterException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import javax.print.PrintService;
import javax.print.PrintServiceLookup;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.KeyStroke;
import javax.swing.ListModel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class TextBatchPrintingDemo
implements HyperlinkListener,
ListSelectionListener {
    static String defaultPage = "index.html";
    static String defaultMessage = "Select: Alt-A  Print: Alt-P  Quit: Alt-Q";
    static PrintService printService = PrintServiceLookup.lookupDefaultPrintService();
    PageItem pageItem;
    URL homePage;
    Map<URL, PageItem> pageCache = new HashMap<URL, PageItem>();
    JList selectedPages;
    JLabel messageArea;

    void printSelectedPages() {
        DefaultListModel pages = (DefaultListModel)this.selectedPages.getModel();
        int n = pages.getSize();
        if (n < 1) {
            this.messageArea.setText("No pages selected");
            return;
        }
        if (printService == null) {
            this.messageArea.setText("No print service");
            return;
        }
        for (int i = 0; i < n; ++i) {
            final PageItem item = (PageItem)pages.getElementAt(i);
            Runnable printTask = new Runnable(){

                public void run() {
                    try {
                        item.print(null, null, false, printService, null, false);
                    }
                    catch (PrinterException pe) {
                        JOptionPane.showMessageDialog(null, "Error printing " + item.getPage() + "\n" + pe, "Print Error", 2);
                    }
                }
            };
            new Thread(printTask).start();
        }
        pages.removeAllElements();
        this.messageArea.setText(n + (n > 1 ? " pages" : " page") + " printed");
    }

    public void hyperlinkUpdate(HyperlinkEvent e) {
        URL url = e.getURL();
        HyperlinkEvent.EventType type = e.getEventType();
        if (type == HyperlinkEvent.EventType.ENTERED) {
            this.messageArea.setText("Go to " + url);
        } else if (type == HyperlinkEvent.EventType.EXITED) {
            this.messageArea.setText(defaultMessage);
        } else if (type == HyperlinkEvent.EventType.ACTIVATED) {
            this.setPage(url);
            this.messageArea.setText(defaultMessage);
        }
    }

    public void valueChanged(ListSelectionEvent e) {
        PageItem item;
        URL page;
        int index;
        if (!e.getValueIsAdjusting() && (index = ((JList)e.getSource()).getSelectedIndex()) >= 0 && !(page = (item = (PageItem)this.selectedPages.getModel().getElementAt(index)).getPage()).equals(this.pageItem.getPage())) {
            this.setPage(page);
        }
    }

    void setPage(URL url) {
        Container p;
        PageItem item = this.pageCache.get(url);
        if (item == null) {
            item = this.createPageItem(url);
            this.pageCache.put(url, item);
        }
        if (this.pageItem != null && (p = this.pageItem.getParent()) != null) {
            p.remove(this.pageItem);
            p.add(item);
        }
        this.pageItem = item;
        this.updateSelectedPages();
    }

    void updateSelectedPages() {
        ListModel pages = this.selectedPages.getModel();
        int n = pages.getSize();
        if (n > 0) {
            PageItem selected;
            URL page = this.pageItem.getPage();
            int index = this.selectedPages.getSelectedIndex();
            if (index >= 0 && page.equals((selected = (PageItem)pages.getElementAt(index)).getPage())) {
                return;
            }
            for (int i = 0; i < n; ++i) {
                PageItem pi = (PageItem)pages.getElementAt(i);
                if (!page.equals(pi.getPage())) continue;
                this.selectedPages.setSelectedIndex(i);
                return;
            }
            this.selectedPages.clearSelection();
        }
    }

    PageItem createPageItem(URL url) {
        PageItem item = new PageItem();
        item.setPreferredSize(new Dimension(800, 600));
        item.setEditable(false);
        item.addHyperlinkListener(this);
        try {
            item.setPage(url);
        }
        catch (IOException ioe) {
            this.messageArea.setText("Error loading " + url + ": " + ioe);
        }
        return item;
    }

    JMenuItem createMenuItem(Action action, int mnemonics, KeyStroke accel) {
        JMenuItem item = new JMenuItem(action);
        item.setMnemonic(mnemonics);
        item.setAccelerator(accel);
        return item;
    }

    void createAndShowGUI() {
        this.messageArea = new JLabel(defaultMessage);
        this.selectedPages = new JList(new DefaultListModel());
        this.selectedPages.setSelectionMode(0);
        this.selectedPages.addListSelectionListener(this);
        this.setPage(this.homePage);
        JSplitPane pane = new JSplitPane(1, new JScrollPane(this.pageItem), new JScrollPane(this.selectedPages));
        JMenu fileMenu = new JMenu("File");
        fileMenu.setMnemonic(70);
        fileMenu.add(this.createMenuItem(new AbstractAction("Add Page"){

            public void actionPerformed(ActionEvent e) {
                DefaultListModel pages = (DefaultListModel)TextBatchPrintingDemo.this.selectedPages.getModel();
                pages.addElement(TextBatchPrintingDemo.this.pageItem);
                TextBatchPrintingDemo.this.selectedPages.setSelectedIndex(pages.getSize() - 1);
            }
        }, 65, KeyStroke.getKeyStroke(65, 8)));
        fileMenu.add(this.createMenuItem(new AbstractAction("Print Selected"){

            public void actionPerformed(ActionEvent e) {
                TextBatchPrintingDemo.this.printSelectedPages();
            }
        }, 80, KeyStroke.getKeyStroke(80, 8)));
        fileMenu.add(this.createMenuItem(new AbstractAction("Clear Selected"){

            public void actionPerformed(ActionEvent e) {
                DefaultListModel pages = (DefaultListModel)TextBatchPrintingDemo.this.selectedPages.getModel();
                pages.removeAllElements();
            }
        }, 67, KeyStroke.getKeyStroke(67, 8)));
        fileMenu.addSeparator();
        fileMenu.add(this.createMenuItem(new AbstractAction("Home Page"){

            public void actionPerformed(ActionEvent e) {
                TextBatchPrintingDemo.this.setPage(TextBatchPrintingDemo.this.homePage);
            }
        }, 72, KeyStroke.getKeyStroke(72, 8)));
        fileMenu.add(this.createMenuItem(new AbstractAction("Quit"){

            public void actionPerformed(ActionEvent e) {
                for (Window w : Window.getWindows()) {
                    w.dispose();
                }
            }
        }, 65, KeyStroke.getKeyStroke(81, 8)));
        JMenuBar menuBar = new JMenuBar();
        menuBar.add(fileMenu);
        JPanel contentPane = new JPanel();
        contentPane.setLayout(new BoxLayout(contentPane, 1));
        contentPane.add(pane);
        contentPane.add(this.messageArea);
        JFrame frame = new JFrame("Text Batch Printing Demo");
        frame.setDefaultCloseOperation(3);
        frame.setJMenuBar(menuBar);
        frame.setContentPane(contentPane);
        frame.pack();
        frame.setLocationRelativeTo(null);
        frame.setVisible(true);
        if (printService == null) {
            JOptionPane.showMessageDialog(frame, "No default print service", "Print Service Alert", 2);
        }
    }

    public static void main(String[] args) {
        final TextBatchPrintingDemo demo = new TextBatchPrintingDemo();
        demo.homePage = demo.getClass().getResource(defaultPage);
        if (args.length > 0) {
            String pageName = args[0];
            try {
                URL url;
                demo.homePage = url = new URL(pageName);
            }
            catch (MalformedURLException e) {
                System.out.println("Error parsing " + pageName + ": " + e);
            }
        }
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                UIManager.put("swing.boldMetal", Boolean.FALSE);
                demo.createAndShowGUI();
            }
        });
    }

    static class PageItem
    extends JEditorPane {
        String title;

        PageItem() {
        }

        public String toString() {
            if (this.title == null) {
                String s = (String)this.getDocument().getProperty("title");
                this.title = s == null ? this.getPage().toString() : s;
            }
            return this.title;
        }
    }
}

