/*
 * Decompiled with CFR 0.152.
 */
package components;

import components.MissingIcon;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.image.BufferedImage;
import java.net.URL;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;

public class IconDemoApp
extends JFrame {
    private JLabel photographLabel = new JLabel();
    private JToolBar buttonBar = new JToolBar();
    private String imagedir = "images/";
    private MissingIcon placeholderIcon = new MissingIcon();
    private String[] imageCaptions = new String[]{"Original SUNW Logo", "The Clocktower", "Clocktower from the West", "The Mansion", "Sun Auditorium"};
    private String[] imageFileNames = new String[]{"sunw01.jpg", "sunw02.jpg", "sunw03.jpg", "sunw04.jpg", "sunw05.jpg"};
    private SwingWorker<Void, ThumbnailAction> loadimages = new SwingWorker<Void, ThumbnailAction>(){

        @Override
        protected Void doInBackground() throws Exception {
            for (int i = 0; i < IconDemoApp.this.imageCaptions.length; ++i) {
                ThumbnailAction thumbAction;
                ImageIcon icon = IconDemoApp.this.createImageIcon(IconDemoApp.this.imagedir + IconDemoApp.this.imageFileNames[i], IconDemoApp.this.imageCaptions[i]);
                if (icon != null) {
                    ImageIcon thumbnailIcon = new ImageIcon(IconDemoApp.this.getScaledImage(icon.getImage(), 32, 32));
                    thumbAction = new ThumbnailAction(icon, thumbnailIcon, IconDemoApp.this.imageCaptions[i]);
                } else {
                    thumbAction = new ThumbnailAction(IconDemoApp.this.placeholderIcon, IconDemoApp.this.placeholderIcon, IconDemoApp.this.imageCaptions[i]);
                }
                this.publish(thumbAction);
            }
            return null;
        }

        @Override
        protected void process(List<ThumbnailAction> chunks) {
            for (ThumbnailAction thumbAction : chunks) {
                JButton thumbButton = new JButton(thumbAction);
                IconDemoApp.this.buttonBar.add((Component)thumbButton, IconDemoApp.this.buttonBar.getComponentCount() - 1);
            }
        }
    };

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                IconDemoApp app = new IconDemoApp();
                app.setVisible(true);
            }
        });
    }

    public IconDemoApp() {
        this.setDefaultCloseOperation(3);
        this.setTitle("Icon Demo: Please Select an Image");
        this.photographLabel.setVerticalTextPosition(3);
        this.photographLabel.setHorizontalTextPosition(0);
        this.photographLabel.setHorizontalAlignment(0);
        this.photographLabel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.buttonBar.add(Box.createGlue());
        this.buttonBar.add(Box.createGlue());
        this.add((Component)this.buttonBar, "South");
        this.add((Component)this.photographLabel, "Center");
        this.setSize(400, 300);
        this.setLocationRelativeTo(null);
        this.loadimages.execute();
    }

    protected ImageIcon createImageIcon(String path, String description) {
        URL imgURL = this.getClass().getResource(path);
        if (imgURL != null) {
            return new ImageIcon(imgURL, description);
        }
        System.err.println("Couldn't find file: " + path);
        return null;
    }

    private Image getScaledImage(Image srcImg, int w, int h) {
        BufferedImage resizedImg = new BufferedImage(w, h, 1);
        Graphics2D g2 = resizedImg.createGraphics();
        g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        g2.drawImage(srcImg, 0, 0, w, h, null);
        g2.dispose();
        return resizedImg;
    }

    private class ThumbnailAction
    extends AbstractAction {
        private Icon displayPhoto;

        public ThumbnailAction(Icon photo, Icon thumb, String desc) {
            this.displayPhoto = photo;
            this.putValue("ShortDescription", desc);
            this.putValue("SwingLargeIconKey", thumb);
        }

        public void actionPerformed(ActionEvent e) {
            IconDemoApp.this.photographLabel.setIcon(this.displayPhoto);
            IconDemoApp.this.setTitle("Icon Demo: " + this.getValue("ShortDescription").toString());
        }
    }
}

