/*
 * Decompiled with CFR 0.152.
 */
package integratedprogressdemo;

import integratedprogressdemo.WeatherData;
import java.awt.Component;
import java.awt.Container;
import java.net.URL;
import javax.jnlp.DownloadServiceListener;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;

public class IntegratedProgressIndicator
implements DownloadServiceListener {
    Container surfaceContainer = null;
    JFrame frame = null;
    WeatherData weatherDataPanel = null;
    IntegratedProgressIndicator integratedProgressIndicator = null;

    public IntegratedProgressIndicator(Object surface) {
        try {
            this.surfaceContainer = (Container)surface;
        }
        catch (ClassCastException cce) {
            cce.printStackTrace();
        }
        this.create();
    }

    private void create() {
        this.weatherDataPanel = new WeatherData(true);
        if (this.surfaceContainer != null) {
            this.surfaceContainer.add((Component)this.weatherDataPanel, "North");
        } else {
            this.frame = new JFrame();
            this.frame.getContentPane().add((Component)this.weatherDataPanel, "Center");
            this.frame.setBounds(300, 300, 400, 300);
        }
    }

    public void downloadFailed(URL url, String version) {
        System.out.println("Download failed");
    }

    public void progress(URL url, String version, long readSoFar, long total, int overallPercent) {
        this.updateProgressUI(overallPercent);
    }

    public void upgradingArchive(URL url, String version, int patchPercent, int overallPercent) {
        this.updateProgressUI(overallPercent);
    }

    public void validating(URL url, String version, long entry, long total, int overallPercent) {
        this.updateProgressUI(overallPercent);
    }

    private void updateProgressUI(int overallPercent) {
        this.weatherDataPanel.updateProgress(overallPercent);
        if (this.frame != null) {
            if (overallPercent < 99) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        IntegratedProgressIndicator.this.frame.setVisible(true);
                    }
                });
            } else {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        IntegratedProgressIndicator.this.frame.setVisible(false);
                        IntegratedProgressIndicator.this.frame.dispose();
                    }
                });
            }
        }
    }
}

