/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.tutorial.jdbc;

import com.oracle.tutorial.jdbc.ExampleRowSetListener;
import com.oracle.tutorial.jdbc.JDBCTutorialUtilities;
import com.sun.rowset.CachedRowSetImpl;
import java.net.MalformedURLException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.GregorianCalendar;
import javax.sql.rowset.spi.SyncProviderException;
import javax.sql.rowset.spi.SyncResolver;

public class CachedRowSetSample {
    private String dbName;
    private Connection con;
    private String dbms;
    private JDBCTutorialUtilities settings;

    public CachedRowSetSample(Connection connArg, JDBCTutorialUtilities settingsArg) {
        this.con = connArg;
        this.dbName = settingsArg.dbName;
        this.dbms = settingsArg.dbms;
        this.settings = settingsArg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testPaging() throws SQLException, MalformedURLException {
        CachedRowSetImpl crs = null;
        this.con.setAutoCommit(false);
        try {
            crs = new CachedRowSetImpl();
            crs.setUsername(this.settings.userName);
            crs.setPassword(this.settings.password);
            if (this.dbms.equals("mysql")) {
                crs.setUrl(this.settings.urlString + "?relaxAutoCommit=true");
            } else {
                crs.setUrl(this.settings.urlString);
            }
            crs.setCommand("select * from MERCH_INVENTORY");
            crs.setPageSize(100);
            crs.execute();
            crs.addRowSetListener(new ExampleRowSetListener());
            int i = 1;
            do {
                System.out.println("Page number: " + i);
                while (crs.next()) {
                    System.out.println("Found item " + crs.getInt("ITEM_ID") + ": " + crs.getString("ITEM_NAME"));
                    if (crs.getInt("ITEM_ID") != 1235) continue;
                    int currentQuantity = crs.getInt("QUAN") + 1;
                    System.out.println("Updating quantity to " + currentQuantity);
                    crs.updateInt("QUAN", currentQuantity + 1);
                    crs.updateRow();
                    crs.acceptChanges(this.con);
                }
                ++i;
            } while (crs.nextPage());
            int newItemId = 123456;
            if (this.doesItemIdExist(newItemId)) {
                System.out.println("Item ID " + newItemId + " already exists");
            } else {
                crs.previousPage();
                crs.moveToInsertRow();
                crs.updateInt("ITEM_ID", newItemId);
                crs.updateString("ITEM_NAME", "TableCloth");
                crs.updateInt("SUP_ID", 927);
                crs.updateInt("QUAN", 14);
                GregorianCalendar timeStamp = new GregorianCalendar();
                timeStamp.set(2006, 4, 1);
                crs.updateTimestamp("DATE_VAL", new Timestamp(timeStamp.getTimeInMillis()));
                crs.insertRow();
                crs.moveToCurrentRow();
                System.out.println("About to add a new row...");
                crs.acceptChanges(this.con);
                System.out.println("Added a row...");
                CachedRowSetSample.viewTable(this.con);
            }
        }
        catch (SyncProviderException spe) {
            SyncResolver resolver = spe.getSyncResolver();
            while (resolver.nextConflict()) {
                if (resolver.getStatus() != 2) continue;
                int row = resolver.getRow();
                crs.absolute(row);
                int colCount = crs.getMetaData().getColumnCount();
                for (int j = 1; j <= colCount; ++j) {
                    if (resolver.getConflictValue(j) == null) continue;
                    Object crsValue = crs.getObject(j);
                    Object resolverValue = resolver.getConflictValue(j);
                    Object resolvedValue = crsValue;
                    resolver.setResolvedValue(j, resolvedValue);
                }
            }
        }
        catch (SQLException sqle) {
            JDBCTutorialUtilities.printSQLException(sqle);
        }
        finally {
            if (crs != null) {
                crs.close();
            }
            this.con.setAutoCommit(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean doesItemIdExist(int id) throws SQLException {
        String query = "select ITEM_ID from MERCH_INVENTORY where ITEM_ID = " + id;
        try (Statement stmt = null;){
            stmt = this.con.createStatement();
            ResultSet rs = stmt.executeQuery(query);
            if (rs.next()) {
                boolean bl = true;
                return bl;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void viewTable(Connection con) throws SQLException {
        String query = "select * from MERCH_INVENTORY";
        try (Statement stmt = null;){
            stmt = con.createStatement();
            ResultSet rs = stmt.executeQuery(query);
            while (rs.next()) {
                System.out.println("Found item " + rs.getInt("ITEM_ID") + ": " + rs.getString("ITEM_NAME") + " (" + rs.getInt("QUAN") + ")");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        JDBCTutorialUtilities myJDBCTutorialUtilities;
        Connection myConnection = null;
        if (args[0] == null) {
            System.err.println("Properties file not specified at command line");
            return;
        }
        try {
            myJDBCTutorialUtilities = new JDBCTutorialUtilities(args[0]);
        }
        catch (Exception e) {
            System.err.println("Problem reading properties file " + args[0]);
            e.printStackTrace();
            return;
        }
        try {
            myConnection = myJDBCTutorialUtilities.getConnection();
            if (myJDBCTutorialUtilities == null) {
                System.out.println("myJDBCTU is null");
            }
            if (myConnection == null) {
                System.out.println("myConnection is null");
            }
            CachedRowSetSample myCachedRowSetSample = new CachedRowSetSample(myConnection, myJDBCTutorialUtilities);
            CachedRowSetSample.viewTable(myConnection);
            myCachedRowSetSample.testPaging();
        }
        catch (SQLException e) {
            JDBCTutorialUtilities.printSQLException(e);
        }
        catch (Exception ex) {
            System.out.println("Unexpected exception");
            ex.printStackTrace();
        }
        finally {
            JDBCTutorialUtilities.closeConnection(myConnection);
        }
    }
}

