/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.tutorial.jdbc;

import com.oracle.tutorial.jdbc.CoffeesTableModel;
import com.oracle.tutorial.jdbc.JDBCTutorialUtilities;
import com.sun.rowset.CachedRowSetImpl;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.RowSetEvent;
import javax.sql.RowSetListener;
import javax.sql.rowset.CachedRowSet;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;

public class CoffeesFrame
extends JFrame
implements RowSetListener {
    JDBCTutorialUtilities settings;
    Connection connection;
    JTable table;
    JLabel label_COF_NAME;
    JLabel label_SUP_ID;
    JLabel label_PRICE;
    JLabel label_SALES;
    JLabel label_TOTAL;
    JTextField textField_COF_NAME;
    JTextField textField_SUP_ID;
    JTextField textField_PRICE;
    JTextField textField_SALES;
    JTextField textField_TOTAL;
    JButton button_ADD_ROW;
    JButton button_UPDATE_DATABASE;
    JButton button_DISCARD_CHANGES;
    CoffeesTableModel myCoffeesTableModel;

    public CoffeesFrame(JDBCTutorialUtilities settingsArg) throws SQLException {
        super("The Coffee Break: COFFEES Table");
        this.settings = settingsArg;
        this.connection = this.settings.getConnection();
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                try {
                    CoffeesFrame.this.connection.close();
                }
                catch (SQLException sqle) {
                    JDBCTutorialUtilities.printSQLException(sqle);
                }
                System.exit(0);
            }
        });
        CachedRowSet myCachedRowSet = this.getContentsOfCoffeesTable();
        this.myCoffeesTableModel = new CoffeesTableModel(myCachedRowSet);
        this.myCoffeesTableModel.addEventHandlersToRowSet(this);
        this.table = new JTable();
        this.table.setModel(this.myCoffeesTableModel);
        this.label_COF_NAME = new JLabel();
        this.label_SUP_ID = new JLabel();
        this.label_PRICE = new JLabel();
        this.label_SALES = new JLabel();
        this.label_TOTAL = new JLabel();
        this.textField_COF_NAME = new JTextField(10);
        this.textField_SUP_ID = new JTextField(10);
        this.textField_PRICE = new JTextField(10);
        this.textField_SALES = new JTextField(10);
        this.textField_TOTAL = new JTextField(10);
        this.button_ADD_ROW = new JButton();
        this.button_UPDATE_DATABASE = new JButton();
        this.button_DISCARD_CHANGES = new JButton();
        this.label_COF_NAME.setText("Coffee Name:");
        this.label_SUP_ID.setText("Supplier ID:");
        this.label_PRICE.setText("Price:");
        this.label_SALES.setText("Sales:");
        this.label_TOTAL.setText("Total Sales:");
        this.textField_COF_NAME.setText("Enter new coffee name");
        this.textField_SUP_ID.setText("101");
        this.textField_PRICE.setText("0");
        this.textField_SALES.setText("0");
        this.textField_TOTAL.setText("0");
        this.button_ADD_ROW.setText("Add row to table");
        this.button_UPDATE_DATABASE.setText("Update database");
        this.button_DISCARD_CHANGES.setText("Discard changes");
        Container contentPane = this.getContentPane();
        contentPane.setComponentOrientation(ComponentOrientation.LEFT_TO_RIGHT);
        contentPane.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        c.anchor = 10;
        c.weightx = 0.5;
        c.weighty = 1.0;
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 2;
        contentPane.add((Component)new JScrollPane(this.table), c);
        c.fill = 2;
        c.anchor = 21;
        c.weightx = 0.25;
        c.weighty = 0.0;
        c.gridx = 0;
        c.gridy = 1;
        c.gridwidth = 1;
        contentPane.add((Component)this.label_COF_NAME, c);
        c.fill = 2;
        c.anchor = 22;
        c.weightx = 0.75;
        c.weighty = 0.0;
        c.gridx = 1;
        c.gridy = 1;
        c.gridwidth = 1;
        contentPane.add((Component)this.textField_COF_NAME, c);
        c.fill = 2;
        c.weightx = 0.25;
        c.weighty = 0.0;
        c.anchor = 21;
        c.gridx = 0;
        c.gridy = 2;
        c.gridwidth = 1;
        contentPane.add((Component)this.label_SUP_ID, c);
        c.fill = 2;
        c.anchor = 22;
        c.weightx = 0.75;
        c.weighty = 0.0;
        c.gridx = 1;
        c.gridy = 2;
        c.gridwidth = 1;
        contentPane.add((Component)this.textField_SUP_ID, c);
        c.fill = 2;
        c.anchor = 21;
        c.weightx = 0.25;
        c.weighty = 0.0;
        c.gridx = 0;
        c.gridy = 3;
        c.gridwidth = 1;
        contentPane.add((Component)this.label_PRICE, c);
        c.fill = 2;
        c.anchor = 22;
        c.weightx = 0.75;
        c.weighty = 0.0;
        c.gridx = 1;
        c.gridy = 3;
        c.gridwidth = 1;
        contentPane.add((Component)this.textField_PRICE, c);
        c.fill = 2;
        c.anchor = 21;
        c.weightx = 0.25;
        c.weighty = 0.0;
        c.gridx = 0;
        c.gridy = 4;
        c.gridwidth = 1;
        contentPane.add((Component)this.label_SALES, c);
        c.fill = 2;
        c.anchor = 22;
        c.weightx = 0.75;
        c.weighty = 0.0;
        c.gridx = 1;
        c.gridy = 4;
        c.gridwidth = 1;
        contentPane.add((Component)this.textField_SALES, c);
        c.fill = 2;
        c.anchor = 21;
        c.weightx = 0.25;
        c.weighty = 0.0;
        c.gridx = 0;
        c.gridy = 5;
        c.gridwidth = 1;
        contentPane.add((Component)this.label_TOTAL, c);
        c.fill = 2;
        c.anchor = 22;
        c.weightx = 0.75;
        c.weighty = 0.0;
        c.gridx = 1;
        c.gridy = 5;
        c.gridwidth = 1;
        contentPane.add((Component)this.textField_TOTAL, c);
        c.fill = 2;
        c.anchor = 21;
        c.weightx = 0.5;
        c.weighty = 0.0;
        c.gridx = 0;
        c.gridy = 6;
        c.gridwidth = 1;
        contentPane.add((Component)this.button_ADD_ROW, c);
        c.fill = 2;
        c.anchor = 22;
        c.weightx = 0.5;
        c.weighty = 0.0;
        c.gridx = 1;
        c.gridy = 6;
        c.gridwidth = 1;
        contentPane.add((Component)this.button_UPDATE_DATABASE, c);
        c.fill = 2;
        c.anchor = 21;
        c.weightx = 0.5;
        c.weighty = 0.0;
        c.gridx = 0;
        c.gridy = 7;
        c.gridwidth = 1;
        contentPane.add((Component)this.button_DISCARD_CHANGES, c);
        this.button_ADD_ROW.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JOptionPane.showMessageDialog(CoffeesFrame.this, new String[]{"Adding the following row:", "Coffee name: [" + CoffeesFrame.this.textField_COF_NAME.getText() + "]", "Supplier ID: [" + CoffeesFrame.this.textField_SUP_ID.getText() + "]", "Price: [" + CoffeesFrame.this.textField_PRICE.getText() + "]", "Sales: [" + CoffeesFrame.this.textField_SALES.getText() + "]", "Total: [" + CoffeesFrame.this.textField_TOTAL.getText() + "]"});
                try {
                    CoffeesFrame.this.myCoffeesTableModel.insertRow(CoffeesFrame.this.textField_COF_NAME.getText(), Integer.parseInt(CoffeesFrame.this.textField_SUP_ID.getText().trim()), Float.parseFloat(CoffeesFrame.this.textField_PRICE.getText().trim()), Integer.parseInt(CoffeesFrame.this.textField_SALES.getText().trim()), Integer.parseInt(CoffeesFrame.this.textField_TOTAL.getText().trim()));
                }
                catch (SQLException sqle) {
                    CoffeesFrame.this.displaySQLExceptionDialog(sqle);
                }
            }
        });
        this.button_UPDATE_DATABASE.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    CoffeesFrame.this.myCoffeesTableModel.coffeesRowSet.acceptChanges();
                }
                catch (SQLException sqle) {
                    CoffeesFrame.this.displaySQLExceptionDialog(sqle);
                    try {
                        CoffeesFrame.this.createNewTableModel();
                    }
                    catch (SQLException sqle2) {
                        CoffeesFrame.this.displaySQLExceptionDialog(sqle2);
                    }
                }
            }
        });
        this.button_DISCARD_CHANGES.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    CoffeesFrame.this.createNewTableModel();
                }
                catch (SQLException sqle) {
                    CoffeesFrame.this.displaySQLExceptionDialog(sqle);
                }
            }
        });
    }

    private void displaySQLExceptionDialog(SQLException e) {
        JOptionPane.showMessageDialog(this, new String[]{e.getClass().getName() + ": ", e.getMessage()});
    }

    private void createNewTableModel() throws SQLException {
        this.myCoffeesTableModel = new CoffeesTableModel(this.getContentsOfCoffeesTable());
        this.myCoffeesTableModel.addEventHandlersToRowSet(this);
        this.table.setModel(this.myCoffeesTableModel);
    }

    public static void main(String[] args) throws Exception {
        JDBCTutorialUtilities myJDBCTutorialUtilities;
        if (args[0] == null) {
            System.err.println("Properties file not specified at command line");
            return;
        }
        try {
            myJDBCTutorialUtilities = new JDBCTutorialUtilities(args[0]);
        }
        catch (Exception e) {
            System.err.println("Problem reading properties file " + args[0]);
            e.printStackTrace();
            return;
        }
        try {
            CoffeesFrame qf = new CoffeesFrame(myJDBCTutorialUtilities);
            qf.pack();
            qf.setVisible(true);
        }
        catch (SQLException sqle) {
            JDBCTutorialUtilities.printSQLException(sqle);
        }
        catch (Exception e) {
            System.out.println("Unexpected exception");
            e.printStackTrace();
        }
    }

    public CachedRowSet getContentsOfCoffeesTable() throws SQLException {
        CachedRowSetImpl crs = null;
        try {
            this.connection = this.settings.getConnection();
            crs = new CachedRowSetImpl();
            crs.setType(1004);
            crs.setConcurrency(1008);
            crs.setUsername(this.settings.userName);
            crs.setPassword(this.settings.password);
            if (this.settings.dbms.equals("mysql")) {
                crs.setUrl(this.settings.urlString + "?relaxAutoCommit=true");
            } else {
                crs.setUrl(this.settings.urlString);
            }
            crs.setCommand("select COF_NAME, SUP_ID, PRICE, SALES, TOTAL from COFFEES");
            crs.execute();
        }
        catch (SQLException e) {
            JDBCTutorialUtilities.printSQLException(e);
        }
        return crs;
    }

    public void actionPerformed(ActionEvent event) {
    }

    @Override
    public void rowSetChanged(RowSetEvent event) {
    }

    @Override
    public void rowChanged(RowSetEvent event) {
        CachedRowSet currentRowSet = this.myCoffeesTableModel.coffeesRowSet;
        try {
            currentRowSet.moveToCurrentRow();
            this.myCoffeesTableModel = new CoffeesTableModel(this.myCoffeesTableModel.getCoffeesRowSet());
            this.table.setModel(this.myCoffeesTableModel);
        }
        catch (SQLException ex) {
            JDBCTutorialUtilities.printSQLException(ex);
            JOptionPane.showMessageDialog(this, new String[]{ex.getClass().getName() + ": ", ex.getMessage()});
        }
    }

    @Override
    public void cursorMoved(RowSetEvent event) {
    }
}

