/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.tutorial.jdbc;

import com.oracle.tutorial.jdbc.JDBCTutorialUtilities;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.Proxy;
import java.net.URL;
import java.net.URLConnection;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public class DatalinkSample {
    private String dbName;
    private Connection con;
    private String dbms;
    private JDBCTutorialUtilities settings;
    private static String proxy = "http://www-proxy.us.oracle.com:80";

    public DatalinkSample(Connection connArg, JDBCTutorialUtilities settingsArg) {
        this.con = connArg;
        this.dbName = settingsArg.dbName;
        this.dbms = settingsArg.dbms;
        this.settings = settingsArg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void viewTable(Connection con, Proxy proxy) throws SQLException, IOException {
        String query = "SELECT document_name, url FROM data_repository";
        try (Statement stmt = null;){
            stmt = con.createStatement();
            ResultSet rs = stmt.executeQuery(query);
            if (rs.next()) {
                String documentName = null;
                URL url = null;
                documentName = rs.getString(1);
                url = rs.getURL(2);
                if (url != null) {
                    URLConnection myURLConnection = url.openConnection(proxy);
                    BufferedReader bReader = new BufferedReader(new InputStreamReader(myURLConnection.getInputStream()));
                    System.out.println("Document name: " + documentName);
                    String pageContent = null;
                    while ((pageContent = bReader.readLine()) != null) {
                        System.out.println(pageContent);
                    }
                } else {
                    System.out.println("URL is null");
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addURLRow(String description, String url) throws SQLException {
        try (PreparedStatement pstmt = null;){
            pstmt = this.con.prepareStatement("INSERT INTO data_repository(document_name,url) VALUES (?,?)");
            pstmt.setString(1, description);
            pstmt.setURL(2, new URL(url));
            pstmt.execute();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        JDBCTutorialUtilities myJDBCTutorialUtilities;
        Connection myConnection = null;
        if (args[0] == null) {
            System.err.println("Properties file not specified at command line");
            return;
        }
        try {
            myJDBCTutorialUtilities = new JDBCTutorialUtilities(args[0]);
        }
        catch (Exception e) {
            System.err.println("Problem reading properties file " + args[0]);
            e.printStackTrace();
            return;
        }
        try {
            myConnection = myJDBCTutorialUtilities.getConnection();
            DatalinkSample myDatalinkSample = new DatalinkSample(myConnection, myJDBCTutorialUtilities);
            myDatalinkSample.addURLRow("Oracle", "http://www.oracle.com");
            DatalinkSample.viewTable(myConnection, Proxy.NO_PROXY);
        }
        catch (SQLException e) {
            JDBCTutorialUtilities.printSQLException(e);
        }
        catch (Exception ex) {
            System.out.println("Unexpected exception");
            ex.printStackTrace();
        }
        finally {
            JDBCTutorialUtilities.closeConnection(myConnection);
        }
    }
}

