/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.tutorial.jdbc;

import com.oracle.tutorial.jdbc.JDBCTutorialUtilities;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public class SuppliersTable {
    private String dbName;
    private Connection con;
    private String dbms;

    public SuppliersTable(Connection connArg, String dbNameArg, String dbmsArg) {
        this.con = connArg;
        this.dbName = dbNameArg;
        this.dbms = dbmsArg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createTable() throws SQLException {
        String createString = "create table SUPPLIERS (SUP_ID integer NOT NULL, SUP_NAME varchar(40) NOT NULL, STREET varchar(40) NOT NULL, CITY varchar(20) NOT NULL, STATE char(2) NOT NULL, ZIP char(5), PRIMARY KEY (SUP_ID))";
        try (Statement stmt = null;){
            stmt = this.con.createStatement();
            stmt.executeUpdate(createString);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dropTable() throws SQLException {
        try (Statement stmt = null;){
            stmt = this.con.createStatement();
            if (this.dbms.equals("mysql")) {
                System.out.println("Dropping table SUPPLIERS from MySQL");
                stmt.executeUpdate("DROP TABLE IF EXISTS SUPPLIERS");
            } else if (this.dbms.equals("derby")) {
                stmt.executeUpdate("DROP TABLE SUPPLIERS");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void populateTable() throws SQLException {
        try (Statement stmt = null;){
            stmt = this.con.createStatement();
            stmt.executeUpdate("insert into SUPPLIERS values(49, 'Superior Coffee', '1 Party Place', 'Mendocino', 'CA', '95460')");
            stmt.executeUpdate("insert into SUPPLIERS values(101, 'Acme, Inc.', '99 Market Street', 'Groundsville', 'CA', '95199')");
            stmt.executeUpdate("insert into SUPPLIERS values(150, 'The High Ground', '100 Coffee Lane', 'Meadows', 'CA', '93966')");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void viewSuppliers() throws SQLException {
        String query = "select SUP_NAME, SUP_ID from SUPPLIERS";
        try (Statement stmt = null;){
            stmt = this.con.createStatement();
            ResultSet rs = stmt.executeQuery(query);
            System.out.println("Suppliers and their ID Numbers:");
            while (rs.next()) {
                String s = rs.getString("SUP_NAME");
                int n = rs.getInt("SUP_ID");
                System.out.println(s + "   " + n);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void viewTable(Connection con) throws SQLException {
        String query = "select SUP_ID, SUP_NAME, STREET, CITY, STATE, ZIP from SUPPLIERS";
        try (Statement stmt = null;){
            stmt = con.createStatement();
            ResultSet rs = stmt.executeQuery(query);
            while (rs.next()) {
                int supplierID = rs.getInt("SUP_ID");
                String supplierName = rs.getString("SUP_NAME");
                String street = rs.getString("STREET");
                String city = rs.getString("CITY");
                String state = rs.getString("STATE");
                String zip = rs.getString("ZIP");
                System.out.println(supplierName + "(" + supplierID + "): " + street + ", " + city + ", " + state + ", " + zip);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        JDBCTutorialUtilities myJDBCTutorialUtilities;
        Connection myConnection = null;
        if (args[0] == null) {
            System.err.println("Properties file not specified at command line");
            return;
        }
        try {
            myJDBCTutorialUtilities = new JDBCTutorialUtilities(args[0]);
        }
        catch (Exception e) {
            System.err.println("Problem reading properties file " + args[0]);
            e.printStackTrace();
            return;
        }
        try {
            myConnection = myJDBCTutorialUtilities.getConnection();
            System.out.println("\nContents of SUPPLIERS table:");
            SuppliersTable.viewTable(myConnection);
        }
        catch (SQLException e) {
            JDBCTutorialUtilities.printSQLException(e);
        }
        finally {
            JDBCTutorialUtilities.closeConnection(myConnection);
        }
    }
}

