/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.tutorial.jdbc;

import com.oracle.tutorial.jdbc.JDBCTutorialUtilities;
import com.sun.rowset.WebRowSetImpl;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;

public class WebRowSetSample {
    private String dbName;
    private Connection con;
    private String dbms;
    private JDBCTutorialUtilities settings;

    public WebRowSetSample(Connection connArg, JDBCTutorialUtilities settingsArg) {
        this.con = connArg;
        this.dbName = settingsArg.dbName;
        this.dbms = settingsArg.dbms;
        this.settings = settingsArg;
    }

    public void testWebRowSet() throws SQLException, IOException {
        FileReader fReader = null;
        FileWriter fWriter = null;
        String priceListFileName = "pricelist.xml";
        int[] keyCols = new int[]{1};
        WebRowSetImpl priceList = new WebRowSetImpl();
        priceList.setUsername(this.settings.userName);
        priceList.setPassword(this.settings.password);
        priceList.setUrl(this.settings.urlString);
        priceList.setCommand("select COF_NAME, PRICE from COFFEES");
        priceList.setKeyColumns(keyCols);
        priceList.execute();
        System.out.println("Size of the WebRowSet is: " + priceList.size());
        priceList.moveToInsertRow();
        priceList.updateString("COF_NAME", "Kona");
        priceList.updateFloat("PRICE", 8.99f);
        priceList.insertRow();
        priceList.moveToCurrentRow();
        System.out.println("New row inserted");
        System.out.println("Size of the WebRowSet is: " + priceList.size());
        priceList.beforeFirst();
        while (priceList.next()) {
            if (!priceList.getString(1).equals("Espresso")) continue;
            System.out.println("Deleting row with Espresso...");
            priceList.deleteRow();
            break;
        }
        priceList.beforeFirst();
        while (priceList.next()) {
            if (!priceList.getString(1).equals("Colombian")) continue;
            System.out.println("Updating row with Colombian...");
            priceList.updateFloat(2, 6.99f);
            priceList.updateRow();
            break;
        }
        int size1 = priceList.size();
        fWriter = new FileWriter(priceListFileName);
        priceList.writeXml(fWriter);
        fWriter.flush();
        fWriter.close();
        WebRowSetImpl receiver = new WebRowSetImpl();
        receiver.setUrl(this.settings.urlString);
        receiver.setUsername(this.settings.userName);
        receiver.setPassword(this.settings.password);
        fReader = new FileReader(priceListFileName);
        receiver.readXml(fReader);
        int size2 = receiver.size();
        if (size1 == size2) {
            System.out.println("WebRowSet serialized and deserialiazed properly");
        } else {
            System.out.println("Error....serializing/deserializng the WebRowSet");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        JDBCTutorialUtilities myJDBCTutorialUtilities;
        Connection myConnection = null;
        if (args[0] == null) {
            System.err.println("Properties file not specified at command line");
            return;
        }
        try {
            myJDBCTutorialUtilities = new JDBCTutorialUtilities(args[0]);
        }
        catch (Exception e) {
            System.err.println("Problem reading properties file " + args[0]);
            e.printStackTrace();
            return;
        }
        try {
            myConnection = myJDBCTutorialUtilities.getConnection();
            WebRowSetSample myWebRowSetSample = new WebRowSetSample(myConnection, myJDBCTutorialUtilities);
            myWebRowSetSample.testWebRowSet();
        }
        catch (SQLException e) {
            JDBCTutorialUtilities.printSQLException(e);
        }
        catch (Exception ex) {
            System.out.println("Unexpected exception");
            ex.printStackTrace();
        }
        finally {
            JDBCTutorialUtilities.closeConnection(myConnection);
        }
    }
}

